# Help

## User Manual

* General functions - first steps
	* [Account basics](help/user/account-basics)
	* [Quick start for new users](help/user/quick-start/guide)
	* [Creating posts](help/user/text-editor)
	* [BBCode tag reference](help/user/bbcode)
	* [Comment, sort and delete posts](help/user/text-comment)
	* [Accesskey reference](help/user/access-keys)
	* [Events](help/user/events)
	* [Themes](help/user/themes)
* You and other users
	* [Connectors](help/user/connectors)
	* [Making friends](help/user/making-friends)
	* [Safety](help/user/safety)
	* [Circles and privacy](help/user/circles-and-privacy)
	* [Tags and mentions](help/user/tags-and-mentions)
	* [Account types: Groups and Pages](help/user/accounts-groups-pages)
	* [Channels](help/user/channels)
	* [Chats](help/user/chats)
* Further information
	* [Frequently asked questions (FAQ)](help/user/faq)
	* [Moving an account](help/user/move-account)
	* [Export / Import of followed Contacts](help/user/export-import-contacts)
	* [Deleting an account](help/user/delete-account)
	* [Bugs and issues](help/user/bugs-and-issues)

## Admin Manual

* [Installation](help/admin/install)
* [Updating](help/admin/update)
* [Frequently asked questions (FAQ)](help/admin/faq)
* [Settings & Admin Panel](help/admin/settings)
* [Installing Connectors](help/admin/installing-connectors)
* [Installing an ejabberd server (XMPP chat) with synchronized credentials](help/admin/install-ejabberd)
* [Using SSL with Friendica](help/admin/ssl)
* [Config values that can only be set in config/local.config.php](help/admin/config)
* [Improving performance](help/admin/improve-performance)
* [Migrating to a new server](help/admin/migrate)
* [Administration tools](help/admin/tools)
* [Monitoring](help/admin/monitoring)

## Developer Manual

* [Get started](help/developer/index)
* Set up development environment
	* [On GitHub](help/developer/github)
	* [On Vagrant](help/developer/vagrant)
* Code structure
    * [Domain-driven design](help/developer/domain-driven-design)
	* [Addon development](help/developer/addon-development)
	* [Smarty 3 templates](help/developer/smarty3-templates)
	* [Storage backend addon](help/developer/addon-storage-backend)
* How To
	* [Translating Friendica](help/developer/translations)
	* [Using Composer](help/developer/composer)
	* [Moving classes to the src directory](help/developer/how-to-move-classes-to-src)
	* [Run tests](help/developer/tests)
* Reference
	* [API endpoints](help/spec/api/index)
	* [Code (Doxygen generated - sets cookies)](doc/html/)
	* [Protocol documentation](help/spec/protocol/protocol)
	* [Database schema documentation](help/spec/database/index)
	* [Class autoloading](help/developer/autoloader)

## Links

* Website: [https://friendi.ca](https://friendi.ca)
* Help Group: [@helpers@forum.friendi.ca](https://forum.friendi.ca/~helpers)
* XMPP: [support@forum.friendi.ca](xmpp:support@forum.friendi.ca?join)
* IRC: [https://web.libera.chat/?channels=#friendica](https://web.libera.chat/?channels=#friendica)
* Matrix: [https://matrix.to/#/#friendi.ca:matrix.org](https://matrix.to/#/#friendi.ca:matrix.org)
* Mailing list: [https://mailman.friendi.ca/mailman/listinfo/support-friendi.ca](http://mailman.friendi.ca/mailman/listinfo/support-friendi.ca)

## About

* [Server information](friendica)
* [Terms of service](tos)
* [Credits](credits)
