# Account basics

## Registration

Not all Friendica sites allow open registration.
If registration is allowed, you will see a "Register" link immediately below the login prompt on the site's home page.
Following this link will take you to the site registration page.
The strength of our network is that lots of different sites are all completely compatible with each other.
If the site you're visiting doesn't allow registration, or you think you might prefer another one, there is a [list of public servers here](https://dir.friendica.social/servers) and hopefully you will find one that meets your needs.

If you'd like to have your own server, you can do that too.
Visit [the Friendica website](http://friendi.ca/) to download the code with setup instructions.
It's a very simple installation process that anybody experienced in hosting websites, or with basic Linux experience can handle easily.

### OpenID

The first field on the Registration page is for an OpenID address.
If you do not have an OpenID address or do not wish to use OpenID, leave this field blank.
If you have an OpenID account elsewhere and wish to use it, enter the address into this field and click 'Register'.
Friendica will attempt to extract as much information as possible from your OpenID provider and return to this page with those items already filled in.

### Your Display Name

Please provide your display name **as you would like it to be displayed on this system**.
Some people use their real name for this, but you're under no obligation to do so yourself.

### Email Address

Please provide a valid email address.
Your email address is **never** published.
We need this to send you account information and your login details.
You may also occasionally receive notifications of incoming messages or items requiring your attention, but you have the possibility to completely disable these from your Settings page once you have logged in.
This doesn't have to be your primary email address, but it does need to be a real email address.
You can't get your initial password, or reset a lost password later without it.
This is the only bit of personal information that has to be accurate.

### Nickname

A nickname is used to generate web addresses for many of your personal pages, and is also treated like an email address when establishing communications with others.
Due to the way that the nickname is used, it has some limitations.
It must contain only US-ASCII text characters and numbers, and must also start with a text character.
It also must be unique on this system.
This is used in many places to identify your account, and once set it cannot be changed.

### Directory Publishing

The registration form also allows you to choose whether or not to list your account in the online directory of your node.
This is like a "phone book" and you may choose to be unlisted.
We recommend that you select 'Yes' so that other people (friends, family, etc.) will be able to find you.
If you choose 'No', you will essentially be invisible and have few opportunities for interaction.
Whichever you choose, this can be changed any time from your Settings page after you log in.

### Register

Once you have provided the necessary details, click the 'Register' button.
An email will be sent to you providing your account login details.
Please check your email (including spam folders) for your registration details and initial password.

## Login Page

On the 'Login' page, please enter your login information that was provided during registration.
You may use either your nickname or email address as a Login Name.

If you use your account to manage other accounts and these all have the same email address, please enter the nickname for the account you wish to manage.

If your account has been OpenID enabled, you may use your OpenID address as a login name and leave the password blank.
You will be redirected to your OpenID provider to complete your authorisation.

Otherwise, enter your password.
This will have been initially provided in your registration email message.
Your password is case-sensitive, so please check your 'Caps Lock' key if you are having difficulty logging in.

## Changing Your Password

After your first login, please visit the 'Settings' page from the top menu bar and change your password to something that you will remember.

## Getting Started

A link with ['Tips for New Members'](newmember) will show up on your network and home pages for two weeks providing key information for getting started.

## Retrieving Personal Data

You can export a copy of your personal data in JSON format from the "Export personal data" link at the top of your settings page.

You need this file to relocate your Friendica account to another node.
This might be necessary, e.g. if your node suffers a severe hardware problem and is not recoverable.

## See Also

- [Account types: Groups and Pages](help/user/accounts-groups-pages)
- [Global directory](help/user/making-friends#the+directories)
- [Circles and privacy](help/user/circles-and-privacy)
- [Moving an account](help/user/move-account)
- [Deleting an account](help/user/delete-account)
