# Friendica BBCode tags reference

* [Creating posts](help/user/text-editor)

## Inline

<style>
table.bbcodes {
    margin: 1em 0;
    background-color: #f9f9f9;
    border: 1px solid #aaa;
    border-collapse: collapse;
    color: #000;
    width: 100%;
}

table.bbcodes > tr > th,
table.bbcodes > tr > td,
table.bbcodes > * > tr > th,
table.bbcodes > * > tr > td {
    border: 1px solid #aaa;
    padding: 0.2em 0.4em
}

table.bbcodes > tr > th,
table.bbcodes > * > tr > th {
    background-color: #f2f2f2;
    text-align: center;
    width: 50%
}
</style>

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[b]bold[/b]</td>
  <td><strong>bold</strong></td>
</tr>
<tr>
  <td>[i]italic[/i]</td>
  <td><em>italic</em></td>
</tr>
<tr>
  <td>[u]underlined[/u]</td>
  <td><u>underlined</u></td>
</tr>
<tr>
  <td>[s]strike[/s]</td>
  <td><strike>strike</strike></td>
</tr>
<tr>
  <td>[o]overline[/o]</td>
  <td><span class="overline">overline</span></td>
</tr>
<tr>
  <td>[color=red]red[/color]</td>
  <td><span style="color:  red;">red</span></td>
</tr>
<tr>
  <td>[url=https://friendi.ca]Friendica[/url]</td>
  <td><a href="https://friendi.ca" target="external-link">Friendica</a></td>
</tr>
<tr>
  <td>[img]https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica-32.png[/img]</td>
  <td><img src="https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica-32.png"></td>
</tr>
<tr>
  <td>[img=https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica-32.png]The Friendica Logo[/img]</td>
  <td><img src="https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica-32.png" alt="The Friendica Logo"></td>
</tr>
<tr>
  <td>[img=64x32]https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica.svg[/img]<br>
<br>Note: provided height is simply discarded.</td>
  <td><img src="https://raw.githubusercontent.com/friendica/friendica/stable/images/friendica.svg" style="width: 64px;"></td>
</tr>
<tr>
  <td>[size=xx-small]small text[/size]</td>
  <td><span style="font-size: xx-small;">small text</span></td>
</tr>
<tr>
  <td>[size=xx-large]big text[/size]</td>
  <td><span style="font-size: xx-large;">big text</span></td>
</tr>
<tr>
  <td>[size=20]exact size[/size] (size can be any number, in pixels)</td>
  <td><span style="font-size: 20px;">exact size</span></td>
</tr>
<tr>
  <td>[font=serif]Serif font[/font]</td>
  <td><span style="font-family: serif;">Serif font</span></td>
</tr>
</table>

### Links

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[url]https://friendi.ca[/url]</td>
  <td><a href="https://friendi.ca">https://friendi.ca</a></td>
</tr>
<tr>
  <td>[url=https://friendi.ca]Friendica[/url]</td>
  <td><a href="https://friendi.ca">Friendica</a></td>
</tr>
<tr>
  <td>[bookmark]https://friendi.ca[/bookmark]<br><br>
#^[url]https://friendi.ca[/url]</td>
  <td><span class="oembed link"><h4>Friendica: <a href="https://friendi.ca" rel="oembed"></a><a href="https://friendi.ca" target="_blank" rel="noopener noreferrer">https://friendi.ca</a></h4></span></td>
</tr>
<tr>
  <td>[bookmark=https://friendi.ca]Bookmark[/bookmark]<br><br>
#^[url=https://friendi.ca]Bookmark[/url]<br><br>
#[url=https://friendi.ca]^[/url][url=https://friendi.ca]Bookmark[/url]</td>
  <td><span class="oembed link"><h4>Friendica: <a href="https://friendi.ca" rel="oembed"></a><a href="https://friendi.ca" target="_blank" rel="noopener noreferrer">Bookmark</a></h4></span></td>
</tr>
<tr>
  <td>[url=/posts/f16d77b0630f0134740c0cc47a0ea02a]Diaspora post with GUID[/url]</td>
  <td><a href="/display/f16d77b0630f0134740c0cc47a0ea02a" target="_blank" rel="noopener noreferrer">Diaspora post with GUID</a></td>
</tr>
<tr>
  <td>#Friendica</td>
  <td>#<a href="/search?tag=Friendica">Friendica</a></td>
</tr>
<tr>
  <td>@Mention</td>
  <td>@<a href="javascript:void(0)">Mention</a></td>
</tr>
<tr>
  <td>acct:account@friendica.host.com (WebFinger)</td>
  <td><a href="/acctlink?addr=account@friendica.host.com" target="extlink">acct:account@friendica.host.com</a></td>
</tr>
<tr>
  <td>[mail]user@mail.example.com[/mail]</td>
  <td><a href="mailto:user@mail.example.com">user@mail.example.com</a></td>
</tr>
<tr>
  <td>[mail=user@mail.example.com]Send an email to User[/mail]</td>
  <td><a href="mailto:user@mail.example.com">Send an email to User</a></td>
</tr>
</table>

## Blocks

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[p]A paragraph of text[/p]</td>
  <td><p>A paragraph of text</p></td>
</tr>
<tr>
  <td>Inline [code]code[/code] in a paragraph</td>
  <td>Inline <key>code</key> in a paragraph</td>
</tr>
<tr>
  <td>[code]Multi<br>line<br>code[/code]</td>
  <td><code>Multi
line
code</code></td>
</tr>
<tr>
  <td>[code=php]function text_highlight($s,$lang)[/code]<sup><a href="#supported-code">1</a></sup></td>
  <td><code><div class="hl-main"><ol class="hl-main"><li><span class="hl-code"> </span><span class="hl-reserved">function</span><span class="hl-code"> </span><span class="hl-identifier">text_highlight</span><span class="hl-brackets">(</span><span class="hl-var">$s</span><span class="hl-code">,</span><span class="hl-var">$lang</span><span class="hl-brackets">)</span></li></ol></div></code></td>
</tr>
<tr>
  <td>[quote]quote[/quote]</td>
  <td><blockquote>quote</blockquote></td>
</tr>
<tr>
  <td>[quote=Author]Author? Me? No, no, no...[/quote]</td>
  <td><strong class="author">Author wrote:</strong><blockquote>Author? Me? No, no, no...</blockquote></td>
</tr>
<tr>
  <td>[center]Centered text[/center]</td>
  <td><div style="text-align:center;">Centered text</div></td>
</tr>
<tr>
  <td>You should not read any further if you want to be surprised.[spoiler]There is a happy end.[/spoiler]</td>
  <td>
    <div class="wall-item-container">
      You should not read any further if you want to be surprised.<br>
      <span id="spoiler-wrap-0716e642" class="spoiler-wrap fakelink" onclick="openClose('spoiler-0716e642');">Click to open/close</span>
      <blockquote class="spoiler" id="spoiler-0716e642" style="display: none;">There is a happy end.</blockquote>
      <div class="body-attach"></div>
    </div>
  </td>
</tr>
<tr>
  <td>[spoiler=Author]Spoiler quote[/spoiler]</td>
  <td>
    <div class="wall-item-container">
      <strong class="spoiler">Author wrote:</strong><br>
      <span id="spoiler-wrap-a893765a" class="spoiler-wrap fakelink" onclick="openClose('spoiler-a893765a');">Click to open/close</span>
      <blockquote class="spoiler" id="spoiler-a893765a" style="display: none;">Spoiler quote</blockquote>
      <div class="body-attach"></div>
    </div>
  </td>
</tr>
<tr>
  <td>[hr] (horizontal line)</td>
  <td><hr></td>
</tr>
</table>

<a name="supported-code">1</a>: Supported language parameter values for code highlighting:
- abap
- avrc
- cpp
- css
- diff
- dtd
- html
- java
- javascript
- js
- mysql
- perl
- php
- python
- ruby
- sh
- sql
- vbscript
- xml

### Titles

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[h1]Title 1[/h1]</td>
  <td><h1>Title 1</h1></td>
</tr>
<tr>
  <td>[h2]Title 2[/h2]</td>
  <td><h2>Title 2</h2></td>
</tr>
<tr>
  <td>[h3]Title 3[/h3]</td>
  <td><h3>Title 3</h3></td>
</tr>
<tr>
  <td>[h4]Title 4[/h4]</td>
  <td><h4>Title 4</h4></td>
</tr>
<tr>
  <td>[h5]Title 5[/h5]</td>
  <td><h5>Title 5</h5></td>
</tr>
<tr>
  <td>[h6]Title 6[/h6]</td>
  <td><h6>Title 6</h6></td>
</tr>
</table>

### Tables

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[table]<br>
  [tr]<br>
    [th]Header 1[/th]<br>
    [th]Header 2[/th]<br>
    [th]Header 2[/th]<br>
  [/tr]<br>
  [tr]<br>
    [td]Cell 1[/td]<br>
    [td]Cell 2[/td]<br>
    [td]Cell 3[/td]<br>
  [/tr]<br>
  [tr]<br>
    [td]Cell 4[/td]<br>
    [td]Cell 5[/td]<br>
    [td]Cell 6[/td]<br>
  [/tr]<br>
[/table]</td>
  <td>
	<table>
      <tbody>
        <tr>
          <th>Header 1</th>
          <th>Header 2</th>
          <th>Header 3</th>
        </tr>
        <tr>
          <td>Cell 1</td>
          <td>Cell 2</td>
          <td>Cell 3</td>
        </tr>
        <tr>
          <td>Cell 4</td>
          <td>Cell 5</td>
          <td>Cell 6</td>
        </tr>
      </tbody>
    </table>
  </td>
</tr>
<tr>
  <td>[table border=0]</td>
  <td>
	<table border="0">
      <tbody>
        <tr>
          <th>Header 1</th>
          <th>Header 2</th>
          <th>Header 3</th>
        </tr>
        <tr>
          <td>Cell 1</td>
          <td>Cell 2</td>
          <td>Cell 3</td>
        </tr>
        <tr>
          <td>Cell 4</td>
          <td>Cell 5</td>
          <td>Cell 6</td>
        </tr>
      </tbody>
    </table>
  </td>
</tr>
<tr>
  <td>[table border=1]</td>
  <td>
	<table border="1">
      <tbody>
        <tr>
          <th>Header 1</th>
          <th>Header 2</th>
          <th>Header 3</th>
        </tr>
        <tr>
          <td>Cell 1</td>
          <td>Cell 2</td>
          <td>Cell 3</td>
        </tr>
        <tr>
          <td>Cell 4</td>
          <td>Cell 5</td>
          <td>Cell 6</td>
        </tr>
      </tbody>
    </table>
  </td>
</tr>
</table>

### Lists

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[ul]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/ul]<br>
[list]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
	<ul class="listbullet" style="list-style-type: circle;">
		<li>First list element</li>
		<li>Second list element</li>
	</ul>
  </td>
</tr>
<tr>
  <td>[ol]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/ol]<br>
[list=1]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listdecimal" style="list-style-type: decimal;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
<tr>
  <td>[list=]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listnone" style="list-style-type: none;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
<tr>
  <td>[list=i]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listlowerroman" style="list-style-type: lower-roman;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
<tr>
  <td>[list=I]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listupperroman" style="list-style-type: upper-roman;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
<tr>
  <td>[list=a]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listloweralpha" style="list-style-type: lower-alpha;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
<tr>
  <td>[list=A]<br>
  [li] First list element<br>
  [li] Second list element<br>
[/list]</td>
  <td>
    <ul class="listupperalpha" style="list-style-type: upper-alpha;">
      <li> First list element</li>
      <li> Second list element</li>
    </ul>
  </td>
</tr>
</table>

## Embed

You can embed video, audio and more in a message.

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[video]url[/video]</td>
  <td>Full URL to a natively supported video file (e.g. MP4, Ogg or WebM). An HTML5 player will be used to show it.</td>
</tr>
<tr>
  <td>[video]Video file url[/video]
[audio]Audio file url[/audio]</td>
  <td>Full URL to a natively supported audio file (e.g. MP3, AAC or FLAC). An HTML5 player will be used to show it.</td>
</tr>
<tr>
  <td>[embed]URL[/embed]</td>
  <td>Embed rich content like a Youtube video or a podcast player.</td>
</tr>
</table>

## Map

This requires "openstreetmap" or "Google Maps" addon version 1.3 or newer.
If the addon isn't activated, the raw coordinates are shown instead.

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[map]address[/map]</td>
  <td>Embeds a map centered on this address.</td>
</tr>
<tr>
  <td>[map=lat,long]</td>
  <td>Embeds a map centered on those coordinates.</td>
</tr>
<tr>
  <td>[map]</td>
  <td>Embeds a map centered on the post's location.</td>
</tr>
</table>

## Abstract for longer posts

If you want to spread your post to several third party networks you may have the problem that these networks have a length limitation like on Twitter.

Friendica uses a semi-intelligent mechanism to generate a fitting abstract.
But it can be useful to define a custom abstract that will only be displayed on the external network.
This is done with the [abstract]-element.
<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>[abstract]Totally interesting! A must-see! Please click the link![/abstract]<br>
I want to tell you a really boring story that you really never wanted to hear.</td>
  <td>Twitter would display the text <blockquote>Totally interesting! A must-see! Please click the link!</blockquote>
On Friendica you would only see the text after <blockquote>I want to tell you a really ...</blockquote></td>
</tr>
</table>

It is even possible to define abstracts for separate networks:

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>
[abstract]Hi friends Here are my newest pictures![/abstract]<br>
[abstract=twit]Hi my dear Twitter followers. Do you want to see my new
pictures?[/abstract]<br>
[abstract=apdn]Helly my dear followers on ADN. I made sone new pictures
that I wanted to share with you.[/abstract]<br>
Today I was in the woods and took some real cool pictures ...</td>
  <td>For Twitter and App.net the system will use the defined abstracts.<br>
For other networks (e.g. when you are using the "StatusNet" connector that is used to post to your GNU Social account) the general abstract element will be used.</td>
</tr>
</table>

If you use (for example) the "buffer" connector to post to Facebook or Google+ you can use this element to define an abstract for a longer blogpost that you don't want to post completely to these networks.

Networks like Facebook or Google+ aren't length limited.
For this reason the [abstract] element isn't used.
Instead you have to name the explicit network:

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>
[abstract]These days I had a strange encounter...[/abstract]<br>
[abstract=goog]Hello my dear Google+ followers. You have to read my newest blog post![/abstract]<br>
[abstract=face]Hello my Facebook friends. These days happened something really cool.[/abstract]<br>
While taking pictures in the woods I had a really strange encounter...</td>
  <td>Google and Facebook will show the respective abstracts while the other networks will show the default one.<br>
<br>Meanwhile, Friendica won't show any of the abstracts.</td>
</tr>
</table>

The [abstract] element is not working with connectors where we post HTML directly, like Tumblr, WordPress or Pump.io.
For the native connections--that is to e.g. Friendica, Hubzilla, Diaspora or GNU Social--the full posting is used and the contacts instance will display the posting as desired.

For postings that are delivered via ActivityPub, the text from the abstract is placed in the summary field.
On Mastodon this field is used for the content warning.

## Special

<table class="bbcodes">
<tr>
  <th>BBCode</th>
  <th>Result</th>
</tr>
<tr>
  <td>If you need to put literal BBCode in a message, [noparse], [nobb] or [pre] blocks prevent BBCode conversion:
    <ul>
      <li>[noparse][b]bold[/b][/noparse]</li>
      <li>[nobb][b]bold[/b][/nobb]</li>
      <li>[pre][b]bold[/b][/pre]</li>
    </ul>
    Note: [code] has priority over [noparse], [nobb] and [pre] which makes them display as BBCode tags in code blocks instead of being removed.
    [code] blocks inside [noparse] will still be converted to a code block.
  </td>
  <td>[b]bold[/b]</td>
</tr>
<tr>
  <td>Additionally, [noparse] and [pre] blocks prevent mention and hashtag conversion to links:
    <ul>
      <li>[noparse]@user@domain.tld #hashtag[/noparse]</li>
      <li>[pre]@user@domain.tld #hashtag[/pre]</li>
    </ul>
  </td>
  <td>@user@domain.tld #hashtag</td>
</tr>
<tr>
  <td>Additionally, [pre] blocks preserve spaces:
    <ul>
      <li>[pre]      Spaces[/pre]</li>
    </ul>
  </td>
  <td>      Spaces</td>
</tr>
<tr>
  <td>[nosmile] is used to disable smilies on a post by post basis<br>
    <br>
    [nosmile] ;-) :-O
  </td>
  <td>;-) :-O</td>
</tr>
<tr>
  <td>Custom block styles<br>
<br>
[style=text-shadow: 0 0 4px #CC0000;]You can change all the CSS properties of this block.[/style]</td>
  <td><div style="text-shadow: 0 0 4px #cc0000;;">You can change all the CSS properties of this block.</div></td>
</tr>
<tr>
  <td>Custom inline styles<br>
<br>
You can change all the [style=text-shadow: 0 0 4px #CC0000;]CSS properties[/style] of this inline text.</td>
  <td>You can change all the <span style="text-shadow: 0 0 4px #cc0000;;">CSS properties</span> of this inline text.</td>
</tr>
</table>
