# Making friends

Friendship in Friendica can sometimes take on different meaning.
But let's keep it simple; you want to be friends with somebody.
How do you do it?

## The Directories

Friendica has two different kinds of "address book".
The directory of the Friendica server you are registered on and a global directory to which your and other Friendica servers submit account information.

The first thing you can do is look at the **Directory**.
The directory is split up into two parts.
If you click the directory button, you will be presented with a list of all members (who chose to be listed) on your server.

You'll also see a link to a **Global Directory**.
There are several global directories across the globe that regularly exchange information with each other.
The specific global directory that you see usually depends on where your server is located.
If you click through to the global directory, you will be presented with a list of everybody who choses to be listed across all instances of Friendica.
You will also see a "Show Community Groups" link, which will direct you to Groups.
You connect to people and groups the same way, public groups will automatically accept your introduction, whereas private groups and some individual users will need to manually approve it.

## Connect to other Friendica users

Visit their profile.
Just beneath their profile picture will be the word 'Connect' (we're assuming this is an English language profile).
Click that 'Connect' button, and it will take you to a 'Connect' form.

The form is going to ask you for your Identity Address.
This is necessary so that this person's website can find yours.

If your Friendica site is called "demo.friendica.com" and your username/nickname on that site is "bob", you would enter "bob@demo.friendica.com" in this form.

Notice this looks just like an email address.
It's meant to be that way.
It's easy for people to remember.

You *could* also put in the URL of your "home" page, such as "http://demo.friendica.com/profile/bob" instead of the email-style address.

When you've submitted the connection page, it will take you back to your own site where you must then log in (if necessary) and verify the connection request on *your* site.
Once you've done this, the two websites can communicate with each other to complete the process (after your new friend has approved the request).

If you already know somebody's Identity Address, you can enter it in the "connect" box on your "Contacts" page.
This will take you through a similar process.


## Connect to users of alternate networks

### Across the Federation and Fediverse
You can also use your Identity Address or other people's Identity Addresses to become friends across the so-called Federation/Fediverse of open source social media.
Currently, Friendica supports connections with people on diaspora*, Red, Hubzilla, GNU Social, StatusNet, Mastodon, Pleroma, socialhome, and ganggo platforms.

If you know (for instance) "alice" on gnusocial.net (a GNU Social site) you could put alice@gnusocial.net into your Contact page and become friends across networks.
Likewise, you can put in the URL to Alice's gnusocial.net page, if you wish.
Note: Some versions of GNU Social software may require the full URL to your profile and may not work with the identity address.

People on these networks can also initiate contact with you, if they know your contact details.

### Other social media
If you server provides this functionality, you can also connect with people one
Twitter or important feeds from Tumblr, WordPress, and many more.

To connect, enter their contact details in the "connect" box on your "Contacts" page.

### Email
If you have supplied your mailbox connection information on your Settings page, you can enter the email address of anybody that has sent you a message recently and have their email messages show up in your social stream.
You can also reply to them from within Friendica.

Create an email contact with for example Alice on Gmail, enter her email in following format "mailto:alice@gmail.no".
In order to avoid abuse or spam, you must have an email from Alice with the correct email address in your email inbox.

Subscribing to mailing lists is done in the same way, but without the use of the "mailto:" prefix.
To subscribe to a mailing list, enter the email in following example format "mailing-list@list-server.net".

### Syndication feeds
You can "follow" almost anybody or any website that produces a syndication feed (RSS/Atom,etc.).
If we can find an information stream and a name to attach to the contact, we'll try to connect with them.

## Notification

When somebody requests friendship you will receive a notification.
You will usually need to approve this before the friendship is complete.

## Approval

Some networks allow people to send you messages without being friends and without your approval.
Friendica does not allow this by default, as it would open a gateway for spam.

## Unilateral or bilateral friendships

When you receive a friendship notification from another Friendica member, you will have the option of allowing them as a "Follower" or as a "Friend".
If they are a follower, they can see what you have to say, including private communications that you send to them, but not vice versa.
As a friend, you can both communicate with each other.

diaspora* uses a different terminology, and you are given the option of allowing them to "share with you", or being full friends.

## Deleting

You can delete a friend no matter what the friendship status - which completely removes everything relating to that person from your website.

## Unwanted Behaviour

If a contact engages in abuse, harrassment, or other unwanted behaviour, there are various actions you can take.
These include:

* Reporting them to your administrator, optionally also their administrator
* Ignoring the contact, so that you will not see their posts
* Blocking the contact from receiving your posts

For more information, see [Safety](help/user/safety).
