<?php

// Copyright (C) 2010-2024, the Friendica project
// SPDX-FileCopyrightText: 2010-2024 the Friendica project
//
// SPDX-License-Identifier: AGPL-3.0-or-later

namespace Friendica\Module\Api\Mastodon\Notifications;

use Friendica\Core\System;
use Friendica\Database\DBA;
use Friendica\DI;
use Friendica\Module\BaseApi;
use Friendica\Network\HTTPException\ForbiddenException;

/**
 * @see https://docs.joinmastodon.org/methods/notifications/
 */
class Dismiss extends BaseApi
{
	protected function post(array $request = [])
	{
		$this->checkAllowedScope(self::SCOPE_WRITE);
		$uid = self::getCurrentUserID();

		if (empty($this->parameters['id'])) {
			$this->logAndJsonError(422, $this->errorFactory->UnprocessableEntity());
		}

		$condition = ['id' => $this->parameters['id']];
		$Notification = DI::notification()->selectOneForUser($uid, $condition);
		$Notification->setDismissed();
		DI::notification()->save($Notification);

		$this->jsonExit([]);
	}
}
