<?php

/* Copyright (C) 2010-2024, the Friendica project
 * SPDX-FileCopyrightText: 2010-2024 the Friendica project
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 *
 * Main view structure configuration file.
 *
 * Here are described all the view Friendica needs to work.
 *
 * Syntax (braces indicate optionale values):
 * "<view name>" => [
 *	"fields" => [
 *		"<field name>" => ["table", "field"],
 *		"<field name>" => "SQL expression",
 *		...
 *	],
 *	"query" => "FROM `table` INNER JOIN `other-table` ..."
 *	],
 * ],
 *
 * If you need to make any change, make sure to increment the DB_UPDATE_VERSION constant value in dbstructure.config.php.
 *
 */

return [
	"application-view" => [
		"fields" => [
			"id" => ["application", "id"],
			"uid" => ["application-token", "uid"],
			"name" => ["application", "name"],
			"redirect_uri" => ["application", "redirect_uri"],
			"website" => ["application", "website"],
			"client_id" => ["application", "client_id"],
			"client_secret" => ["application", "client_secret"],
			"code" => ["application-token", "code"],
			"access_token" => ["application-token", "access_token"],
			"created_at" => ["application-token", "created_at"],
			"scopes" => ["application-token", "scopes"],
			"read" => ["application-token", "read"],
			"write" => ["application-token", "write"],
			"follow" => ["application-token", "follow"],
			"push" => ["application-token", "push"],
		],
		"query" => "FROM `application-token`
			INNER JOIN `application` ON `application-token`.`application-id` = `application`.`id`
			INNER JOIN `user` ON `user`.`uid` = `application-token`.`uid` AND `user`.`verified` AND NOT `user`.`blocked` AND NOT `user`.`account_removed` AND NOT `user`.`account_expired`"
	],
	"circle-member-view" => [
		"fields" => [
			"id" => ["group_member", "id"],
			"uid" => ["group", "uid"],
			"contact-id" => ["group_member", "contact-id"],
			"contact-uri-id" => ["contact", "uri-id"],
			"contact-link" => ["contact", "url"],
			"contact-addr" => ["contact", "addr"],
			"contact-name" => ["contact", "name"],
			"contact-nick" => ["contact", "nick"],
			"contact-avatar" => ["contact", "thumb"],
			"contact-network" => ["contact", "network"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-hidden" => ["contact", "hidden"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-archive" => ["contact", "archive"],
			"contact-pending" => ["contact", "pending"],
			"contact-self" => ["contact", "self"],
			"contact-rel" => ["contact", "rel"],
			"contact-contact-type" => ["contact", "contact-type"],
			"circle-id" => ["group_member", "gid"],
			"circle-visible" => ["group", "visible"],
			"circle-deleted" => ["group", "deleted"],
			"circle-name" => ["group", "name"],
		],
		"query" => "FROM `group_member`
			INNER JOIN `contact` ON `group_member`.`contact-id` = `contact`.`id`
			INNER JOIN `group` ON `group_member`.`gid` = `group`.`id`"
	],
	"post-counts-view" => [
		"fields" => [
			"uri-id" => ["post-counts", "uri-id"],
			"vid" => ["post-counts", "vid"],
			"verb" => ["verb", "name"],
			"reaction" => ["post-counts", "reaction"],
			"parent-uri-id" => ["post-counts", "parent-uri-id"],
			"count" => ["post-counts", "count"],
		],
		"query" => "FROM `post-counts`
			INNER JOIN `verb` ON `verb`.`id` = `post-counts`.`vid`"
	],
	"post-engagement-user-view" => [
		"fields" => [
			"uid" => ["post-thread-user", "uid"],
			"uri-id" => ["post-engagement", "uri-id"],
			"owner-id" => ["post-engagement", "owner-id"],
			"media-type" => ["post-engagement", "media-type"],
			"language" => ["post-engagement", "language"],
			"searchtext" => ["post-engagement", "searchtext"],
			"size" => ["post-engagement", "size"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-thread-user", "received"],
			"created" => ["post-thread-user", "created"],
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"restricted" => ["post-engagement", "language"],
			"comments" => "0",
			"activities" => "0",
		],
		"query" => "FROM `post-thread-user`
			INNER JOIN `post-engagement` ON `post-engagement`.`uri-id` = `post-thread-user`.`uri-id`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-thread-user`.`post-user-id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `authorcontact` ON `authorcontact`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `ownercontact` ON `ownercontact`.`id` = `post-thread-user`.`owner-id`
			WHERE `post-user`.`visible` AND NOT `post-user`.`deleted`
			AND (NOT `contact`.`readonly` AND NOT `contact`.`blocked` AND NOT `contact`.`pending`)
			AND (`post-thread-user`.`hidden` IS NULL OR NOT `post-thread-user`.`hidden`)
			AND NOT `authorcontact`.`blocked` AND NOT `ownercontact`.`blocked`
			AND NOT EXISTS(SELECT `cid`  FROM `user-contact` WHERE `uid` = `post-thread-user`.`uid` AND `cid` IN (`authorcontact`.`id`, `ownercontact`.`id`) AND (`blocked` OR `ignored` OR `is-blocked`))
			AND NOT EXISTS(SELECT `gsid` FROM `user-gserver` WHERE `uid` = `post-thread-user`.`uid` AND `gsid` IN (`authorcontact`.`gsid`, `ownercontact`.`gsid`) AND `ignored`)"
	],
	"post-timeline-view" => [
		"fields" => [
			"uid" => ["post-user", "uid"],
			"uri-id" => ["post-user", "uri-id"],
			"gravity" => ["post-user", "gravity"],
			"created" => ["post-user", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-user", "received"],
			"changed" => ["post-thread-user", "changed"],
			"private" => ["post-user", "private"],
			"visible" => ["post-user", "visible"],
			"deleted" => ["post-user", "deleted"],
			"origin" => ["post-user", "origin"],
			"global" => ["post-user", "global"],
			"network" => ["post-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-user", "vid"],
			"contact-id" => ["post-user", "contact-id"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"self" => ["contact", "self"],
			"author-id" => ["post-user", "author-id"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post-user", "owner-id"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-gsid" => ["owner", "gsid"],
			"causer-id" => ["post-user", "causer-id"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-gsid" => ["causer", "gsid"],
			"parent-network" => ["post-thread-user", "network"],
			"parent-owner-id" => ["post-thread-user", "owner-id"],
			"parent-author-id" => ["post-thread-user", "author-id"],
		],
		"query" => "FROM `post-user`
			LEFT JOIN `post-thread-user` ON `post-thread-user`.`uri-id` = `post-user`.`parent-uri-id` AND `post-thread-user`.`uid` = `post-user`.`uid`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-user`.`causer-id`"
	],
	"post-timeline-origin-view" => [
		"fields" => [
			"uid" => ["post-origin", "uid"],
			"uri-id" => ["post-origin", "uri-id"],
			"gravity" => ["post-origin", "gravity"],
			"created" => ["post-origin", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-origin", "received"],
			"changed" => ["post-thread-user", "changed"],
			"private" => ["post-origin", "private"],
			"visible" => ["post-user", "visible"],
			"deleted" => ["post-user", "deleted"],
			"origin" => "true",
			"global" => ["post-user", "global"],
			"network" => ["post-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-origin", "vid"],
			"contact-id" => ["post-user", "contact-id"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"self" => ["contact", "self"],
			"author-id" => ["post-user", "author-id"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post-user", "owner-id"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-gsid" => ["owner", "gsid"],
			"causer-id" => ["post-user", "causer-id"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-gsid" => ["causer", "gsid"],
		],
		"query" => "FROM `post-origin`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-origin`.`id`
			LEFT JOIN `post-thread-user` ON `post-thread-user`.`uri-id` = `post-origin`.`parent-uri-id` AND `post-thread-user`.`uid` = `post-origin`.`uid`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-user`.`causer-id`"
	],
	"post-searchindex-user-view" => [
		"fields" => [
			"uid" => ["post-thread-user", "uid"],
			"uri-id" => ["post-searchindex", "uri-id"],
			"owner-id" => ["post-searchindex", "owner-id"],
			"media-type" => ["post-searchindex", "media-type"],
			"language" => ["post-searchindex", "language"],
			"searchtext" => ["post-searchindex", "searchtext"],
			"size" => ["post-searchindex", "size"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-thread-user", "received"],
			"created" => ["post-thread-user", "created"],
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"restricted" => ["post-searchindex", "language"],
			"comments" => "0",
			"activities" => "0",
		],
		"query" => "FROM `post-thread-user`
			INNER JOIN `post-searchindex` ON `post-searchindex`.`uri-id` = `post-thread-user`.`uri-id`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-thread-user`.`post-user-id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `authorcontact` ON `authorcontact`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `ownercontact` ON `ownercontact`.`id` = `post-thread-user`.`owner-id`
			WHERE `post-user`.`visible` AND NOT `post-user`.`deleted`
			AND (NOT `contact`.`readonly` AND NOT `contact`.`blocked` AND NOT `contact`.`pending`)
			AND (`post-thread-user`.`hidden` IS NULL OR NOT `post-thread-user`.`hidden`)
			AND NOT `authorcontact`.`blocked` AND NOT `ownercontact`.`blocked`
			AND NOT EXISTS(SELECT `cid`  FROM `user-contact` WHERE `uid` = `post-thread-user`.`uid` AND `cid` IN (`authorcontact`.`id`, `ownercontact`.`id`) AND (`blocked` OR `ignored` OR `is-blocked`))
			AND NOT EXISTS(SELECT `gsid` FROM `user-gserver` WHERE `uid` = `post-thread-user`.`uid` AND `gsid` IN (`authorcontact`.`gsid`, `ownercontact`.`gsid`) AND `ignored`)"
	],
	"post-origin-view" => [
		"fields" => [
			"id" => ["post-origin", "id"],
			"post-user-id" => ["post-origin", "id"],
			"uid" => ["post-origin", "uid"],
			"parent" => ["post-thread-user", "post-user-id"],
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post-origin", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post-origin", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post-origin", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread-user", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread-user", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"wall" => ["post-origin", "wall"],
			"gravity" => ["post-origin", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post-user", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post-user", "replies-id"],
			"created" => ["post-origin", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-origin", "received"],
			"changed" => ["post-thread-user", "changed"],
			"post-type" => ["post-user", "post-type"],
			"post-reason" => ["post-user", "post-reason"],
			"private" => ["post-origin", "private"],
			"pubmail" => ["post-thread-user", "pubmail"],
			"visible" => ["post-user", "visible"],
			"starred" => ["post-thread-user", "starred"],
			"unseen" => ["post-user", "unseen"],
			"deleted" => ["post-user", "deleted"],
			"origin" => "true",
			"parent-origin" => ["post-thread-user", "origin"],
			"mention" => ["post-thread-user", "mention"],
			"global" => ["post-user", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post-origin`.`uri-id`)",
			"network" => ["post-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-origin", "vid"],
			"psid" => ["post-user", "psid"],
			"verb" => "IF (`post-origin`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => "IFNULL (`post-content`.`body`, '')",
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"restrictions" => ["post-user", "restrictions"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post-user", "contact-id"],
			"contact-uri-id" => ["contact", "uri-id"],
			"contact-link" => ["contact", "url"],
			"contact-addr" => ["contact", "addr"],
			"contact-name" => ["contact", "name"],
			"contact-nick" => ["contact", "nick"],
			"contact-avatar" => ["contact", "thumb"],
			"contact-network" => ["contact", "network"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-hidden" => ["contact", "hidden"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-archive" => ["contact", "archive"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"contact-contact-type" => ["contact", "contact-type"],
			"writable" => "IF (`post-user`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `contact`.`writable`)",
			"self" => ["contact", "self"],
			"cid" => ["contact", "id"],
			"alias" => ["contact", "alias"],
			"photo" => ["contact", "photo"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"thumb" => ["contact", "thumb"],
			"author-id" => ["post-user", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`name` != '', `contact`.`name`, `author`.`name`)",
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `author`.`thumb`)",
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"author-baseurl" => ["author", "baseurl"],
			"owner-id" => ["post-user", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`name` != '', `contact`.`name`, `owner`.`name`)",
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `owner`.`thumb`)",
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-gsid" => ["owner", "gsid"],
			"owner-contact-type" => ["owner", "contact-type"],
			"causer-id" => ["post-user", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-gsid" => ["causer", "gsid"],
			"causer-contact-type" => ["causer", "contact-type"],
			"postopts" => ["post-delivery-data", "postopts"],
			"inform" => ["post-delivery-data", "inform"],
			"delivery_queue_count" => ["post-delivery-data", "queue_count"],
			"delivery_queue_done" => ["post-delivery-data", "queue_done"],
			"delivery_queue_failed" => ["post-delivery-data", "queue_failed"],
			"allow_cid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`allow_cid`)",
			"allow_gid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`allow_gid`)",
			"deny_cid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`deny_cid`)",
			"deny_gid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`deny_gid`)",
			"event-id" => ["post-user", "event-id"],
			"event-created" => ["event", "created"],
			"event-edited" => ["event", "edited"],
			"event-start" => ["event", "start"],
			"event-finish" => ["event", "finish"],
			"event-summary" => ["event", "summary"],
			"event-desc" => ["event", "desc"],
			"event-location" => ["event", "location"],
			"event-type" => ["event", "type"],
			"event-nofinish" => ["event", "nofinish"],
			"event-ignore" => ["event", "ignore"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "EXISTS(SELECT `uri-id` FROM `post-category` WHERE `post-category`.`uri-id` = `post-origin`.`uri-id` AND `post-category`.`uid` = `post-origin`.`uid`)",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post-origin`.`uri-id`)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread-user", "network"],
			"parent-owner-id" => ["post-thread-user", "owner-id"],
			"parent-author-id" => ["post-thread-user", "author-id"],
			"parent-author-link" => ["parent-post-author", "url"],
			"parent-author-name" => ["parent-post-author", "name"],
			"parent-author-nick" => ["parent-post-author", "nick"],
			"parent-author-network" => ["parent-post-author", "network"],
		],
		"query" => "FROM `post-origin`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-origin`.`id`
			INNER JOIN `post-thread-user` ON `post-thread-user`.`uri-id` = `post-origin`.`parent-uri-id` AND `post-thread-user`.`uid` = `post-origin`.`uid`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-user`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post-origin`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post-origin`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post-origin`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread-user`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread-user`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post-user`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post-user`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post-origin`.`vid`
			LEFT JOIN `event` ON `event`.`id` = `post-user`.`event-id`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-delivery-data` ON `post-delivery-data`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `permissionset` ON `permissionset`.`id` = `post-user`.`psid`
			LEFT JOIN `contact` AS `parent-post-author` ON `parent-post-author`.`id` = `post-thread-user`.`author-id`"
	],
	"post-thread-origin-view" => [
		"fields" => [
			"id" => ["post-origin", "id"],
			"post-user-id" => ["post-origin", "id"],
			"uid" => ["post-origin", "uid"],
			"parent" => ["post-thread-user", "post-user-id"],
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post-origin", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post-origin", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post-origin", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread-user", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread-user", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"wall" => ["post-origin", "wall"],
			"gravity" => ["post-origin", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post-user", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post-user", "replies-id"],
			"created" => ["post-origin", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-origin", "received"],
			"changed" => ["post-thread-user", "changed"],
			"post-type" => ["post-user", "post-type"],
			"post-reason" => ["post-user", "post-reason"],
			"private" => ["post-origin", "private"],
			"pubmail" => ["post-thread-user", "pubmail"],
			"ignored" => ["post-thread-user", "ignored"],
			"visible" => ["post-user", "visible"],
			"starred" => ["post-thread-user", "starred"],
			"unseen" => ["post-thread-user", "unseen"],
			"deleted" => ["post-user", "deleted"],
			"origin" => "true",
			"mention" => ["post-thread-user", "mention"],
			"global" => ["post-user", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post-thread-user`.`uri-id`)",
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-origin", "vid"],
			"psid" => ["post-thread-user", "psid"],
			"verb" => "IF (`post-origin`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => ["post-content", "body"],
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"restrictions" => ["post-user", "restrictions"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post-thread-user", "contact-id"],
			"contact-uri-id" => ["contact", "uri-id"],
			"contact-link" => ["contact", "url"],
			"contact-addr" => ["contact", "addr"],
			"contact-name" => ["contact", "name"],
			"contact-nick" => ["contact", "nick"],
			"contact-avatar" => ["contact", "thumb"],
			"contact-network" => ["contact", "network"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-hidden" => ["contact", "hidden"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-archive" => ["contact", "archive"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"contact-gsid" => ["contact", "gsid"],
			"contact-contact-type" => ["contact", "contact-type"],
			"writable" => "IF (`post-user`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `contact`.`writable`)",
			"self" => ["contact", "self"],
			"cid" => ["contact", "id"],
			"alias" => ["contact", "alias"],
			"photo" => ["contact", "photo"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"thumb" => ["contact", "thumb"],
			"author-id" => ["post-thread-user", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`name` != '', `contact`.`name`, `author`.`name`)",
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `author`.`thumb`)",
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post-thread-user", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`name` != '', `contact`.`name`, `owner`.`name`)",
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `owner`.`thumb`)",
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-gsid" => ["owner", "gsid"],
			"owner-contact-type" => ["owner", "contact-type"],
			"causer-id" => ["post-thread-user", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-gsid" => ["causer", "gsid"],
			"causer-contact-type" => ["causer", "contact-type"],
			"postopts" => ["post-delivery-data", "postopts"],
			"inform" => ["post-delivery-data", "inform"],
			"delivery_queue_count" => ["post-delivery-data", "queue_count"],
			"delivery_queue_done" => ["post-delivery-data", "queue_done"],
			"delivery_queue_failed" => ["post-delivery-data", "queue_failed"],
			"allow_cid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`allow_cid`)",
			"allow_gid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`allow_gid`)",
			"deny_cid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`deny_cid`)",
			"deny_gid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`deny_gid`)",
			"event-id" => ["post-user", "event-id"],
			"event-created" => ["event", "created"],
			"event-edited" => ["event", "edited"],
			"event-start" => ["event", "start"],
			"event-finish" => ["event", "finish"],
			"event-summary" => ["event", "summary"],
			"event-desc" => ["event", "desc"],
			"event-location" => ["event", "location"],
			"event-type" => ["event", "type"],
			"event-nofinish" => ["event", "nofinish"],
			"event-ignore" => ["event", "ignore"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "EXISTS(SELECT `uri-id` FROM `post-category` WHERE `post-category`.`uri-id` = `post-thread-user`.`uri-id` AND `post-category`.`uid` = `post-thread-user`.`uid`)",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post-thread-user`.`uri-id`)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread-user", "network"],
			"parent-owner-id" => ["post-thread-user", "owner-id"],
			"parent-author-id" => ["post-thread-user", "author-id"],
			"parent-author-link" => ["author", "url"],
			"parent-author-name" => ["author", "name"],
			"parent-author-nick" => ["author", "nick"],
			"parent-author-network" => ["author", "network"],
		],
		"query" => "FROM `post-origin`
			INNER JOIN `post-thread-user` ON `post-thread-user`.`uri-id` = `post-origin`.`uri-id` AND `post-thread-user`.`uid` = `post-origin`.`uid`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-origin`.`id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-thread-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-thread-user`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post-origin`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post-origin`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post-origin`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread-user`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread-user`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post-user`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post-user`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post-origin`.`vid`
			LEFT JOIN `event` ON `event`.`id` = `post-user`.`event-id`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-delivery-data` ON `post-delivery-data`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post-origin`.`uri-id`
			LEFT JOIN `permissionset` ON `permissionset`.`id` = `post-thread-user`.`psid`"
	],
	"post-user-view" => [
		"fields" => [
			"id" => ["post-user", "id"],
			"post-user-id" => ["post-user", "id"],
			"uid" => ["post-user", "uid"],
			"parent" => ["post-thread-user", "post-user-id"],
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post-user", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post-user", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post-user", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread-user", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread-user", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"wall" => ["post-user", "wall"],
			"gravity" => ["post-user", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post-user", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post-user", "replies-id"],
			"created" => ["post-user", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-user", "received"],
			"changed" => ["post-thread-user", "changed"],
			"post-type" => ["post-user", "post-type"],
			"post-reason" => ["post-user", "post-reason"],
			"private" => ["post-user", "private"],
			"pubmail" => ["post-thread-user", "pubmail"],
			"visible" => ["post-user", "visible"],
			"starred" => ["post-thread-user", "starred"],
			"unseen" => ["post-user", "unseen"],
			"deleted" => ["post-user", "deleted"],
			"origin" => ["post-user", "origin"],
			"parent-origin" => ["post-thread-user", "origin"],
			"mention" => ["post-thread-user", "mention"],
			"global" => ["post-user", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post-user`.`uri-id`)",
			"network" => ["post-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-user", "vid"],
			"psid" => ["post-user", "psid"],
			"verb" => "IF (`post-user`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => "IFNULL (`post-content`.`body`, '')",
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"restrictions" => ["post-user", "restrictions"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post-user", "contact-id"],
			"contact-uri-id" => ["contact", "uri-id"],
			"contact-link" => ["contact", "url"],
			"contact-addr" => ["contact", "addr"],
			"contact-name" => ["contact", "name"],
			"contact-nick" => ["contact", "nick"],
			"contact-avatar" => ["contact", "thumb"],
			"contact-network" => ["contact", "network"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-hidden" => ["contact", "hidden"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-archive" => ["contact", "archive"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"contact-contact-type" => ["contact", "contact-type"],
			"writable" => "IF (`post-user`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `contact`.`writable`)",
			"self" => ["contact", "self"],
			"cid" => ["contact", "id"],
			"alias" => ["contact", "alias"],
			"photo" => ["contact", "photo"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"thumb" => ["contact", "thumb"],
			"author-id" => ["post-user", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`name` != '', `contact`.`name`, `author`.`name`)",
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `author`.`thumb`)",
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"author-baseurl" => ["author", "baseurl"],
			"owner-id" => ["post-user", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`name` != '', `contact`.`name`, `owner`.`name`)",
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `owner`.`thumb`)",
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-gsid" => ["owner", "gsid"],
			"owner-contact-type" => ["owner", "contact-type"],
			"causer-id" => ["post-user", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-gsid" => ["causer", "gsid"],
			"causer-contact-type" => ["causer", "contact-type"],
			"postopts" => ["post-delivery-data", "postopts"],
			"inform" => ["post-delivery-data", "inform"],
			"delivery_queue_count" => ["post-delivery-data", "queue_count"],
			"delivery_queue_done" => ["post-delivery-data", "queue_done"],
			"delivery_queue_failed" => ["post-delivery-data", "queue_failed"],
			"allow_cid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`allow_cid`)",
			"allow_gid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`allow_gid`)",
			"deny_cid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`deny_cid`)",
			"deny_gid" => "IF (`post-user`.`psid` IS NULL, '', `permissionset`.`deny_gid`)",
			"event-id" => ["post-user", "event-id"],
			"event-created" => ["event", "created"],
			"event-edited" => ["event", "edited"],
			"event-start" => ["event", "start"],
			"event-finish" => ["event", "finish"],
			"event-summary" => ["event", "summary"],
			"event-desc" => ["event", "desc"],
			"event-location" => ["event", "location"],
			"event-type" => ["event", "type"],
			"event-nofinish" => ["event", "nofinish"],
			"event-ignore" => ["event", "ignore"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "EXISTS(SELECT `uri-id` FROM `post-category` WHERE `post-category`.`uri-id` = `post-user`.`uri-id` AND `post-category`.`uid` = `post-user`.`uid`)",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post-user`.`uri-id`)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread-user", "network"],
			"parent-owner-id" => ["post-thread-user", "owner-id"],
			"parent-author-id" => ["post-thread-user", "author-id"],
			"parent-author-link" => ["parent-post-author", "url"],
			"parent-author-name" => ["parent-post-author", "name"],
			"parent-author-nick" => ["parent-post-author", "nick"],
			"parent-author-network" => ["parent-post-author", "network"],
		],
		"query" => "FROM `post-user`
			INNER JOIN `post-thread-user` ON `post-thread-user`.`uri-id` = `post-user`.`parent-uri-id` AND `post-thread-user`.`uid` = `post-user`.`uid`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-user`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post-user`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post-user`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post-user`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread-user`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread-user`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post-user`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post-user`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post-user`.`vid`
			LEFT JOIN `event` ON `event`.`id` = `post-user`.`event-id`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post-user`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post-user`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-delivery-data` ON `post-delivery-data`.`uri-id` = `post-user`.`uri-id` AND `post-user`.`origin`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post-user`.`uri-id`
			LEFT JOIN `permissionset` ON `permissionset`.`id` = `post-user`.`psid`
			LEFT JOIN `contact` AS `parent-post-author` ON `parent-post-author`.`id` = `post-thread-user`.`author-id`"
	],
	"post-thread-user-view" => [
		"fields" => [
			"id" => ["post-user", "id"],
			"post-user-id" => ["post-user", "id"],
			"uid" => ["post-thread-user", "uid"],
			"parent" => ["post-thread-user", "post-user-id"],
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post-thread-user", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post-user", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post-user", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread-user", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread-user", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"wall" => ["post-thread-user", "wall"],
			"gravity" => ["post-user", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post-user", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post-user", "replies-id"],
			"created" => ["post-thread-user", "created"],
			"edited" => ["post-user", "edited"],
			"commented" => ["post-thread-user", "commented"],
			"received" => ["post-thread-user", "received"],
			"changed" => ["post-thread-user", "changed"],
			"post-type" => ["post-user", "post-type"],
			"post-reason" => ["post-user", "post-reason"],
			"private" => ["post-user", "private"],
			"pubmail" => ["post-thread-user", "pubmail"],
			"ignored" => ["post-thread-user", "ignored"],
			"visible" => ["post-user", "visible"],
			"starred" => ["post-thread-user", "starred"],
			"unseen" => ["post-thread-user", "unseen"],
			"deleted" => ["post-user", "deleted"],
			"origin" => ["post-thread-user", "origin"],
			"mention" => ["post-thread-user", "mention"],
			"global" => ["post-user", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post-thread-user`.`uri-id`)",
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"vid" => ["post-user", "vid"],
			"psid" => ["post-thread-user", "psid"],
			"verb" => "IF (`post-user`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => ["post-content", "body"],
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"restrictions" => ["post-user", "restrictions"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post-thread-user", "contact-id"],
			"contact-uri-id" => ["contact", "uri-id"],
			"contact-link" => ["contact", "url"],
			"contact-addr" => ["contact", "addr"],
			"contact-name" => ["contact", "name"],
			"contact-nick" => ["contact", "nick"],
			"contact-avatar" => ["contact", "thumb"],
			"contact-network" => ["contact", "network"],
			"contact-blocked" => ["contact", "blocked"],
			"contact-hidden" => ["contact", "hidden"],
			"contact-readonly" => ["contact", "readonly"],
			"contact-archive" => ["contact", "archive"],
			"contact-pending" => ["contact", "pending"],
			"contact-rel" => ["contact", "rel"],
			"contact-uid" => ["contact", "uid"],
			"contact-gsid" => ["contact", "gsid"],
			"contact-contact-type" => ["contact", "contact-type"],
			"writable" => "IF (`post-user`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `contact`.`writable`)",
			"self" => ["contact", "self"],
			"cid" => ["contact", "id"],
			"alias" => ["contact", "alias"],
			"photo" => ["contact", "photo"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"thumb" => ["contact", "thumb"],
			"author-id" => ["post-thread-user", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`name` != '', `contact`.`name`, `author`.`name`)",
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => "IF (`contact`.`url` = `author`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `author`.`thumb`)",
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post-thread-user", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`name` != '', `contact`.`name`, `owner`.`name`)",
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => "IF (`contact`.`url` = `owner`.`url` AND `contact`.`thumb` != '', `contact`.`thumb`, `owner`.`thumb`)",
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-gsid" => ["owner", "gsid"],
			"owner-contact-type" => ["owner", "contact-type"],
			"causer-id" => ["post-thread-user", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-gsid" => ["causer", "gsid"],
			"causer-contact-type" => ["causer", "contact-type"],
			"postopts" => ["post-delivery-data", "postopts"],
			"inform" => ["post-delivery-data", "inform"],
			"delivery_queue_count" => ["post-delivery-data", "queue_count"],
			"delivery_queue_done" => ["post-delivery-data", "queue_done"],
			"delivery_queue_failed" => ["post-delivery-data", "queue_failed"],
			"allow_cid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`allow_cid`)",
			"allow_gid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`allow_gid`)",
			"deny_cid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`deny_cid`)",
			"deny_gid" => "IF (`post-thread-user`.`psid` IS NULL, '', `permissionset`.`deny_gid`)",
			"event-id" => ["post-user", "event-id"],
			"event-created" => ["event", "created"],
			"event-edited" => ["event", "edited"],
			"event-start" => ["event", "start"],
			"event-finish" => ["event", "finish"],
			"event-summary" => ["event", "summary"],
			"event-desc" => ["event", "desc"],
			"event-location" => ["event", "location"],
			"event-type" => ["event", "type"],
			"event-nofinish" => ["event", "nofinish"],
			"event-ignore" => ["event", "ignore"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "EXISTS(SELECT `uri-id` FROM `post-category` WHERE `post-category`.`uri-id` = `post-thread-user`.`uri-id` AND `post-category`.`uid` = `post-thread-user`.`uid`)",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post-thread-user`.`uri-id`)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread-user", "network"],
			"parent-owner-id" => ["post-thread-user", "owner-id"],
			"parent-author-id" => ["post-thread-user", "author-id"],
			"parent-author-link" => ["author", "url"],
			"parent-author-name" => ["author", "name"],
			"parent-author-nick" => ["author", "nick"],
			"parent-author-network" => ["author", "network"],
		],
		"query" => "FROM `post-thread-user`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-thread-user`.`post-user-id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-thread-user`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-thread-user`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post-thread-user`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post-user`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post-user`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread-user`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread-user`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post-user`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post-user`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post-user`.`vid`
			LEFT JOIN `event` ON `event`.`id` = `post-user`.`event-id`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post-thread-user`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post-thread-user`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-delivery-data` ON `post-delivery-data`.`uri-id` = `post-thread-user`.`uri-id` AND `post-thread-user`.`origin`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post-thread-user`.`uri-id`
			LEFT JOIN `permissionset` ON `permissionset`.`id` = `post-thread-user`.`psid`"
	],
	"post-view" => [
		"fields" => [
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"gravity" => ["post", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post", "replies-id"],
			"created" => ["post", "created"],
			"edited" => ["post", "edited"],
			"commented" => ["post-thread", "commented"],
			"received" => ["post", "received"],
			"changed" => ["post-thread", "changed"],
			"post-type" => ["post", "post-type"],
			"private" => ["post", "private"],
			"visible" => ["post", "visible"],
			"deleted" => ["post", "deleted"],
			"global" => ["post", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post`.`uri-id`)",
			"network" => ["post", "network"],
			"protocol" => "255",
			"vid" => ["post", "vid"],
			"verb" => "IF (`post`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => ["post-content", "body"],
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post", "author-id"],
			"contact-uri-id" => ["author", "uri-id"],
			"contact-link" => ["author", "url"],
			"contact-addr" => ["author", "addr"],
			"contact-name" => ["author", "name"],
			"contact-nick" => ["author", "nick"],
			"contact-avatar" => ["author", "thumb"],
			"contact-network" => ["author", "network"],
			"contact-blocked" => ["author", "blocked"],
			"contact-hidden" => ["author", "hidden"],
			"contact-readonly" => ["author", "readonly"],
			"contact-archive" => ["author", "archive"],
			"contact-pending" => ["author", "pending"],
			"contact-rel" => ["author", "rel"],
			"contact-uid" => ["author", "uid"],
			"contact-contact-type" => ["author", "contact-type"],
			"writable" => "IF (`post`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `author`.`writable`)",
			"self" => "false",
			"cid" => ["author", "id"],
			"alias" => ["author", "alias"],
			"photo" => ["author", "photo"],
			"name-date" => ["author", "name-date"],
			"uri-date" => ["author", "uri-date"],
			"avatar-date" => ["author", "avatar-date"],
			"thumb" => ["author", "thumb"],
			"author-id" => ["post", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => ["author", "name"],
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => ["author", "thumb"],
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => ["owner", "name"],
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => ["owner", "thumb"],
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-contact-type" => ["owner", "contact-type"],
			"owner-gsid" => ["owner", "gsid"],
			"causer-id" => ["post", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-contact-type" => ["causer", "contact-type"],
			"causer-gsid" => ["causer", "gsid"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "0",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post`.`uri-id`)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread", "network"],
			"parent-owner-id" => ["post-thread", "owner-id"],
			"parent-author-id" => ["post-thread", "author-id"],
			"parent-author-link" => ["parent-post-author", "url"],
			"parent-author-name" => ["parent-post-author", "name"],
			"parent-author-nick" => ["parent-post-author", "nick"],
			"parent-author-network" => ["parent-post-author", "network"],
		],
		"query" => "FROM `post`
			STRAIGHT_JOIN `post-thread` ON `post-thread`.`uri-id` = `post`.`parent-uri-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post`.`vid`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post`.`uri-id`
			LEFT JOIN `contact` AS `parent-post-author` ON `parent-post-author`.`id` = `post-thread`.`author-id`"
	],
	"post-thread-view" => [
		"fields" => [
			"uri" => ["item-uri", "uri"],
			"uri-id" => ["post-thread", "uri-id"],
			"parent-uri" => ["parent-item-uri", "uri"],
			"parent-uri-id" => ["post", "parent-uri-id"],
			"thr-parent" => ["thr-parent-item-uri", "uri"],
			"thr-parent-id" => ["post", "thr-parent-id"],
			"conversation" => ["conversation-item-uri", "uri"],
			"conversation-id" => ["post-thread", "conversation-id"],
			"context" => ["context-item-uri", "uri"],
			"context-id" => ["post-thread", "context-id"],
			"quote-uri" => ["quote-item-uri", "uri"],
			"quote-uri-id" => ["post-content", "quote-uri-id"],
			"guid" => ["item-uri", "guid"],
			"gravity" => ["post", "gravity"],
			"extid" => ["external-item-uri", "uri"],
			"external-id" => ["post", "external-id"],
			"replies" => ["replies-item-uri", "uri"],
			"replies-id" => ["post", "replies-id"],
			"created" => ["post-thread", "created"],
			"edited" => ["post", "edited"],
			"commented" => ["post-thread", "commented"],
			"received" => ["post-thread", "received"],
			"changed" => ["post-thread", "changed"],
			"post-type" => ["post", "post-type"],
			"private" => ["post", "private"],
			"visible" => ["post", "visible"],
			"deleted" => ["post", "deleted"],
			"global" => ["post", "global"],
			"featured" => "EXISTS(SELECT `type` FROM `post-collection` WHERE `type` = 0 AND `uri-id` = `post-thread`.`uri-id`)",
			"network" => ["post-thread", "network"],
			"protocol" => "255",
			"vid" => ["post", "vid"],
			"verb" => "IF (`post`.`vid` IS NULL, '', `verb`.`name`)",
			"title" => ["post-content", "title"],
			"content-warning" => ["post-content", "content-warning"],
			"raw-body" => ["post-content", "raw-body"],
			"body" => ["post-content", "body"],
			"rendered-hash" => ["post-content", "rendered-hash"],
			"rendered-html" => ["post-content", "rendered-html"],
			"language" => ["post-content", "language"],
			"plink" => ["post-content", "plink"],
			"location" => ["post-content", "location"],
			"coord" => ["post-content", "coord"],
			"sensitive" => ["post-content", "sensitive"],
			"app" => ["post-content", "app"],
			"object-type" => ["post-content", "object-type"],
			"object" => ["post-content", "object"],
			"target-type" => ["post-content", "target-type"],
			"target" => ["post-content", "target"],
			"resource-id" => ["post-content", "resource-id"],
			"contact-id" => ["post-thread", "author-id"],
			"contact-uri-id" => ["author", "uri-id"],
			"contact-link" => ["author", "url"],
			"contact-addr" => ["author", "addr"],
			"contact-name" => ["author", "name"],
			"contact-nick" => ["author", "nick"],
			"contact-avatar" => ["author", "thumb"],
			"contact-network" => ["author", "network"],
			"contact-blocked" => ["author", "blocked"],
			"contact-hidden" => ["author", "hidden"],
			"contact-readonly" => ["author", "readonly"],
			"contact-archive" => ["author", "archive"],
			"contact-pending" => ["author", "pending"],
			"contact-rel" => ["author", "rel"],
			"contact-uid" => ["author", "uid"],
			"contact-contact-type" => ["author", "contact-type"],
			"writable" => "IF (`post`.`network` IN ('apub', 'dfrn', 'dspr', 'stat'), true, `author`.`writable`)",
			"self" => "false",
			"cid" => ["author", "id"],
			"alias" => ["author", "alias"],
			"photo" => ["author", "photo"],
			"name-date" => ["author", "name-date"],
			"uri-date" => ["author", "uri-date"],
			"avatar-date" => ["author", "avatar-date"],
			"thumb" => ["author", "thumb"],
			"author-id" => ["post-thread", "author-id"],
			"author-uri-id" => ["author", "uri-id"],
			"author-link" => ["author", "url"],
			"author-addr" => ["author", "addr"],
			"author-name" => ["author", "name"],
			"author-nick" => ["author", "nick"],
			"author-alias" => ["author", "alias"],
			"author-avatar" => ["author", "thumb"],
			"author-network" => ["author", "network"],
			"author-blocked" => ["author", "blocked"],
			"author-hidden" => ["author", "hidden"],
			"author-updated" => ["author", "updated"],
			"author-contact-type" => ["author", "contact-type"],
			"author-gsid" => ["author", "gsid"],
			"owner-id" => ["post-thread", "owner-id"],
			"owner-uri-id" => ["owner", "uri-id"],
			"owner-link" => ["owner", "url"],
			"owner-addr" => ["owner", "addr"],
			"owner-name" => ["owner", "name"],
			"owner-nick" => ["owner", "nick"],
			"owner-alias" => ["owner", "alias"],
			"owner-avatar" => ["owner", "thumb"],
			"owner-network" => ["owner", "network"],
			"owner-blocked" => ["owner", "blocked"],
			"owner-hidden" => ["owner", "hidden"],
			"owner-updated" => ["owner", "updated"],
			"owner-gsid" => ["owner", "gsid"],
			"owner-contact-type" => ["owner", "contact-type"],
			"causer-id" => ["post-thread", "causer-id"],
			"causer-uri-id" => ["causer", "uri-id"],
			"causer-link" => ["causer", "url"],
			"causer-addr" => ["causer", "addr"],
			"causer-name" => ["causer", "name"],
			"causer-nick" => ["causer", "nick"],
			"causer-alias" => ["causer", "alias"],
			"causer-avatar" => ["causer", "thumb"],
			"causer-network" => ["causer", "network"],
			"causer-blocked" => ["causer", "blocked"],
			"causer-hidden" => ["causer", "hidden"],
			"causer-gsid" => ["causer", "gsid"],
			"causer-contact-type" => ["causer", "contact-type"],
			"question-id" => ["post-question", "id"],
			"question-multiple" => ["post-question", "multiple"],
			"question-voters" => ["post-question", "voters"],
			"question-end-time" => ["post-question", "end-time"],
			"has-categories" => "0",
			"has-media" => "EXISTS(SELECT `id` FROM `post-media` WHERE `post-media`.`uri-id` = `post-thread`.`uri-id`)",
			"total-comments" => "(SELECT COUNT(*) FROM `post` WHERE `parent-uri-id` = `post-thread`.`uri-id` AND `gravity` = 6)",
			"total-actors" => "(SELECT COUNT(DISTINCT(`author-id`)) FROM `post` WHERE `parent-uri-id` = `post-thread`.`uri-id` AND `gravity` = 6)",
			"signed_text" => ["diaspora-interaction", "interaction"],
			"parent-guid" => ["parent-item-uri", "guid"],
			"parent-network" => ["post-thread", "network"],
			"parent-owner-id" => ["post-thread", "owner-id"],
			"parent-author-id" => ["post-thread", "author-id"],
			"parent-author-link" => ["author", "url"],
			"parent-author-name" => ["author", "name"],
			"parent-author-nick" => ["author", "nick"],
			"parent-author-network" => ["author", "network"],
		],
		"query" => "FROM `post-thread`
			INNER JOIN `post` ON `post`.`uri-id` = `post-thread`.`uri-id`
			STRAIGHT_JOIN `contact` AS `author` ON `author`.`id` = `post-thread`.`author-id`
			STRAIGHT_JOIN `contact` AS `owner` ON `owner`.`id` = `post-thread`.`owner-id`
			LEFT JOIN `contact` AS `causer` ON `causer`.`id` = `post-thread`.`causer-id`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `post-thread`.`uri-id`
			LEFT JOIN `item-uri` AS `thr-parent-item-uri` ON `thr-parent-item-uri`.`id` = `post`.`thr-parent-id`
			LEFT JOIN `item-uri` AS `parent-item-uri` ON `parent-item-uri`.`id` = `post`.`parent-uri-id`
			LEFT JOIN `item-uri` AS `conversation-item-uri` ON `conversation-item-uri`.`id` = `post-thread`.`conversation-id`
			LEFT JOIN `item-uri` AS `context-item-uri` ON `context-item-uri`.`id` = `post-thread`.`context-id`
			LEFT JOIN `item-uri` AS `external-item-uri` ON `external-item-uri`.`id` = `post`.`external-id`
			LEFT JOIN `item-uri` AS `replies-item-uri` ON `replies-item-uri`.`id` = `post`.`replies-id`
			LEFT JOIN `verb` ON `verb`.`id` = `post`.`vid`
			LEFT JOIN `diaspora-interaction` ON `diaspora-interaction`.`uri-id` = `post-thread`.`uri-id`
			LEFT JOIN `post-content` ON `post-content`.`uri-id` = `post-thread`.`uri-id`
			LEFT JOIN `item-uri` AS `quote-item-uri` ON `quote-item-uri`.`id` = `post-content`.`quote-uri-id`
			LEFT JOIN `post-question` ON `post-question`.`uri-id` = `post-thread`.`uri-id`"
	],
	"category-view" => [
		"fields" => [
			"uri-id" => ["post-category", "uri-id"],
			"uid" => ["post-category", "uid"],
			"type" => ["post-category", "type"],
			"tid" => ["post-category", "tid"],
			"name" => ["tag", "name"],
			"url" => ["tag", "url"],
		],
		"query" => "FROM `post-category`
			LEFT JOIN `tag` ON `post-category`.`tid` = `tag`.`id`"
	],
	"collection-view" => [
		"fields" => [
			"uri-id" => ["post-collection", "uri-id"],
			"type" => ["post-collection", "type"],
			"cid" => ["post-collection", "author-id"],
			"received" => ["post", "received"],
			"created" => ["post", "created"],
			"commented" => ["post-thread", "commented"],
			"private" => ["post", "private"],
			"visible" => ["post", "visible"],
			"deleted" => ["post", "deleted"],
			"thr-parent-id" => ["post", "thr-parent-id"],
			"author-id" => ["post-collection", "author-id"],
			"gravity" => ["post", "gravity"],
		],
		"query" => "FROM `post-collection`
			INNER JOIN `post` ON `post-collection`.`uri-id` = `post`.`uri-id`
			INNER JOIN `post-thread` ON `post-thread`.`uri-id` = `post`.`parent-uri-id`"
	],
	"media-view" => [
		"fields" => [
			"uri-id" => ["post-media", "uri-id"],
			"type" => ["post-media", "type"],
			"received" => ["post", "received"],
			"created" => ["post", "created"],
			"private" => ["post", "private"],
			"visible" => ["post", "visible"],
			"deleted" => ["post", "deleted"],
			"thr-parent-id" => ["post", "thr-parent-id"],
			"author-id" => ["post", "author-id"],
			"gravity" => ["post", "gravity"],
		],
		"query" => "FROM `post-media`
			INNER JOIN `post` ON `post-media`.`uri-id` = `post`.`uri-id`"
	],
	"tag-view" => [
		"fields" => [
			"uri-id" => ["post-tag", "uri-id"],
			"type" => ["post-tag", "type"],
			"tid" => ["post-tag", "tid"],
			"cid" => ["post-tag", "cid"],
			"name" => "CASE `cid` WHEN 0 THEN `tag`.`name` ELSE `contact`.`name` END",
			"url" => "CASE `cid` WHEN 0 THEN `tag`.`url` ELSE `contact`.`url` END",
			"tag-type" => "CASE `cid` WHEN 0 THEN `tag`.`type` ELSE 1 END",
		],
		"query" => "FROM `post-tag`
			LEFT JOIN `tag` ON `post-tag`.`tid` = `tag`.`id`
			LEFT JOIN `contact` ON `post-tag`.`cid` = `contact`.`id`"
	],
	"network-thread-view" => [
		"fields" => [
			"uri-id" => ["post-thread-user", "uri-id"],
			"parent" => ["post-thread-user", "post-user-id"],
			"received" => ["post-thread-user", "received"],
			"commented" => ["post-thread-user", "commented"],
			"created" => ["post-thread-user", "created"],
			"uid" => ["post-thread-user", "uid"],
			"starred" => ["post-thread-user", "starred"],
			"mention" => ["post-thread-user", "mention"],
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"contact-id" => ["post-thread-user", "contact-id"],
			"contact-type" => ["ownercontact", "contact-type"],
		],
		"query" => "FROM `post-thread-user`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-thread-user`.`post-user-id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `authorcontact` ON `authorcontact`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `ownercontact` ON `ownercontact`.`id` = `post-thread-user`.`owner-id`
			WHERE `post-user`.`visible` AND NOT `post-user`.`deleted`
			AND (NOT `contact`.`readonly` AND NOT `contact`.`blocked` AND NOT `contact`.`pending`)
			AND (`post-thread-user`.`hidden` IS NULL OR NOT `post-thread-user`.`hidden`)
			AND NOT `authorcontact`.`blocked` AND NOT `ownercontact`.`blocked`
			AND NOT EXISTS(SELECT `cid`  FROM `user-contact` WHERE `uid` = `post-thread-user`.`uid` AND `cid` IN (`post-thread-user`.`author-id`, `post-thread-user`.`owner-id`, `post-thread-user`.`causer-id`) AND (`blocked` OR `ignored` OR `is-blocked` OR `channel-only`))
			AND NOT EXISTS(SELECT `gsid` FROM `user-gserver` WHERE `uid` = `post-thread-user`.`uid` AND `gsid` IN (`authorcontact`.`gsid`, `ownercontact`.`gsid`) AND `ignored`)"
	],
	"network-thread-circle-view" => [
		"fields" => [
			"uri-id" => ["post-thread-user", "uri-id"],
			"parent" => ["post-thread-user", "post-user-id"],
			"received" => ["post-thread-user", "received"],
			"commented" => ["post-thread-user", "commented"],
			"created" => ["post-thread-user", "created"],
			"uid" => ["post-thread-user", "uid"],
			"starred" => ["post-thread-user", "starred"],
			"mention" => ["post-thread-user", "mention"],
			"network" => ["post-thread-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"contact-id" => ["post-thread-user", "contact-id"],
			"contact-type" => ["ownercontact", "contact-type"],
		],
		"query" => "FROM `post-thread-user`
			INNER JOIN `post-user` ON `post-user`.`id` = `post-thread-user`.`post-user-id`
			STRAIGHT_JOIN `contact` ON `contact`.`id` = `post-thread-user`.`contact-id`
			STRAIGHT_JOIN `contact` AS `authorcontact` ON `authorcontact`.`id` = `post-thread-user`.`author-id`
			STRAIGHT_JOIN `contact` AS `ownercontact` ON `ownercontact`.`id` = `post-thread-user`.`owner-id`
			WHERE `post-user`.`visible` AND NOT `post-user`.`deleted`
			AND (NOT `contact`.`readonly` AND NOT `contact`.`blocked` AND NOT `contact`.`pending`)
			AND (`post-thread-user`.`hidden` IS NULL OR NOT `post-thread-user`.`hidden`)
			AND NOT `authorcontact`.`blocked` AND NOT `ownercontact`.`blocked`
			AND NOT EXISTS(SELECT `cid`  FROM `user-contact` WHERE `uid` = `post-thread-user`.`uid` AND `cid` IN (`post-thread-user`.`author-id`, `post-thread-user`.`owner-id`, `post-thread-user`.`causer-id`) AND (`blocked` OR `ignored` OR `is-blocked`))
			AND NOT EXISTS(SELECT `gsid` FROM `user-gserver` WHERE `uid` = `post-thread-user`.`uid` AND `gsid` IN (`authorcontact`.`gsid`, `ownercontact`.`gsid`) AND `ignored`)"
	],
	"owner-view" => [
		"fields" => [
			"id" => ["contact", "id"],
			"uid" => ["contact", "uid"],
			"created" => ["contact", "created"],
			"updated" => ["contact", "updated"],
			"self" => ["contact", "self"],
			"remote_self" => ["contact", "remote_self"],
			"rel" => ["contact", "rel"],
			"network" => ["contact", "network"],
			"protocol" => ["contact", "protocol"],
			"name" => ["contact", "name"],
			"nick" => ["contact", "nick"],
			"location" => ["contact", "location"],
			"about" => ["contact", "about"],
			"keywords" => ["contact", "keywords"],
			"xmpp" => ["contact", "xmpp"],
			"matrix" => ["contact", "matrix"],
			"attag" => ["contact", "attag"],
			"avatar" => ["contact", "avatar"],
			"photo" => ["contact", "photo"],
			"thumb" => ["contact", "thumb"],
			"micro" => ["contact", "micro"],
			"header" => ["contact", "header"],
			"url" => ["contact", "url"],
			"nurl" => ["contact", "nurl"],
			"uri-id" => ["contact", "uri-id"],
			"addr" => ["contact", "addr"],
			"alias" => ["contact", "alias"],
			"pubkey" => ["contact", "pubkey"],
			"prvkey" => ["contact", "prvkey"],
			"batch" => ["contact", "batch"],
			"request" => ["contact", "request"],
			"notify" => ["contact", "notify"],
			"poll" => ["contact", "poll"],
			"confirm" => ["contact", "confirm"],
			"poco" => ["contact", "poco"],
			"hub-verify" => ["contact", "hub-verify"],
			"last-update" => ["contact", "last-update"],
			"success_update" => ["contact", "success_update"],
			"failure_update" => ["contact", "failure_update"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"picdate" => ["contact", "avatar-date"], /// @todo Replaces all uses of "picdate" with "avatar-date"
			"term-date" => ["contact", "term-date"],
			"last-item" => ["contact", "last-item"],
			"priority" => ["contact", "priority"],
			"blocked" => ["user", "blocked"],
			"block_reason" => ["contact", "block_reason"],
			"readonly" => ["contact", "readonly"],
			"writable" => ["contact", "writable"],
			"forum" => ["contact", "forum"],
			"prv" => ["contact", "prv"],
			"contact-type" => ["contact", "contact-type"],
			"manually-approve" => ["contact", "manually-approve"],
			"hidden" => ["contact", "hidden"],
			"archive" => ["contact", "archive"],
			"pending" => ["contact", "pending"],
			"deleted" => ["contact", "deleted"],
			"unsearchable" => ["contact", "unsearchable"],
			"sensitive" => ["contact", "sensitive"],
			"baseurl" => ["contact", "baseurl"],
			"gsid" => ["contact", "gsid"],
			"reason" => ["contact", "reason"],
			"info" => ["contact", "info"],
			"bdyear" => ["contact", "bdyear"],
			"bd" => ["contact", "bd"],
			"notify_new_posts" => ["contact", "notify_new_posts"],
			"fetch_further_information" => ["contact", "fetch_further_information"],
			"ffi_keyword_denylist" => ["contact", "ffi_keyword_denylist"],
			"parent-uid" => ["user", "parent-uid"],
			"guid" => ["user", "guid"],
			"nickname" => ["user", "nickname"], /// @todo Replaces all uses of "nickname" with "nick"
			"email" => ["user", "email"],
			"openid" => ["user", "openid"],
			"timezone" => ["user", "timezone"],
			"language" => ["user", "language"],
			"register_date" => ["user", "register_date"],
			"login_date" => ["user", "login_date"],
			"last-activity" => ["user", "last-activity"],
			"default-location" => ["user", "default-location"],
			"allow_location" => ["user", "allow_location"],
			"theme" => ["user", "theme"],
			"upubkey" => ["user", "pubkey"],
			"uprvkey" => ["user", "prvkey"],
			"verified" => ["user", "verified"],
			"blockwall" => ["user", "blockwall"],
			"hidewall" => ["user", "hidewall"],
			"blocktags" => ["user", "blocktags"],
			"notify-flags" => ["user", "notify-flags"],
			"page-flags" => ["user", "page-flags"],
			"account-type" => ["user", "account-type"],
			"prvnets" => ["user", "prvnets"],
			"maxreq" => ["user", "maxreq"],
			"expire" => ["user", "expire"],
			"account_removed" => ["user", "account_removed"],
			"account_expired" => ["user", "account_expired"],
			"account_expires_on" => ["user", "account_expires_on"],
			"expire_notification_sent" => ["user", "expire_notification_sent"],
			"def_gid" => ["user", "def_gid"],
			"allow_cid" => ["user", "allow_cid"],
			"allow_gid" => ["user", "allow_gid"],
			"deny_cid" => ["user", "deny_cid"],
			"deny_gid" => ["user", "deny_gid"],
			"openidserver" => ["user", "openidserver"],
			"publish" => ["profile", "publish"],
			"net-publish" => ["profile", "net-publish"],
			"hide-friends" => ["profile", "hide-friends"],
			"prv_keywords" => ["profile", "prv_keywords"],
			"pub_keywords" => ["profile", "pub_keywords"],
			"address" => ["profile", "address"],
			"locality" => ["profile", "locality"],
			"region" => ["profile", "region"],
			"postal-code" => ["profile", "postal-code"],
			"country-name" => ["profile", "country-name"],
			"homepage" => ["profile", "homepage"],
			"homepage_verified" => ["profile", "homepage_verified"],
			"dob" => ["profile", "dob"],
		],
		"query" => "FROM `user`
			INNER JOIN `contact` ON `contact`.`uid` = `user`.`uid` AND `contact`.`self`
			INNER JOIN `profile` ON `profile`.`uid` = `user`.`uid`"
	],
	"account-view" => [
		"fields" => [
			"id" => ["contact", "id"],
			"url" => ["contact", "url"],
			"nurl" => ["contact", "nurl"],
			"uri-id" => ["contact", "uri-id"],
			"guid" => ["item-uri", "guid"],
			"addr" => ["contact", "addr"],
			"alias" => ["contact", "alias"],
			"name" => ["contact", "name"],
			"nick" => ["contact", "nick"],
			"about" => ["contact", "about"],
			"keywords" => ["contact", "keywords"],
			"xmpp" => ["contact", "xmpp"],
			"matrix" => ["contact", "matrix"],
			"avatar" => ["contact", "avatar"],
			"photo" => ["contact", "photo"],
			"thumb" => ["contact", "thumb"],
			"micro" => ["contact", "micro"],
			"header" => ["contact", "header"],
			"created" => ["contact", "created"],
			"updated" => ["contact", "updated"],
			"network" => ["contact", "network"],
			"protocol" => ["contact", "protocol"],
			"location" => ["contact", "location"],
			"attag" => ["contact", "attag"],
			"pubkey" => ["contact", "pubkey"],
			"prvkey" => ["contact", "prvkey"],
			"subscribe" => ["contact", "subscribe"],
			"last-update" => ["contact", "last-update"],
			"success_update" => ["contact", "success_update"],
			"failure_update" => ["contact", "failure_update"],
			"failed" => ["contact", "failed"],
			"last-item" => ["contact", "last-item"],
			"last-discovery" => ["contact", "last-discovery"],
			"contact-type" => ["contact", "contact-type"],
			"manually-approve" => ["contact", "manually-approve"],
			"unsearchable" => ["contact", "unsearchable"],
			"sensitive" => ["contact", "sensitive"],
			"baseurl" => ["contact", "baseurl"],
			"gsid" => ["contact", "gsid"],
			"info" => ["contact", "info"],
			"bdyear" => ["contact", "bdyear"],
			"bd" => ["contact", "bd"],
			"poco" => ["contact", "poco"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"term-date" => ["contact", "term-date"],
			"global-ignored" => ["contact", "hidden"],
			"global-blocked" => ["contact", "blocked"],
			"hidden" => ["contact", "hidden"],
			"archive" => ["contact", "archive"],
			"deleted" => ["contact", "deleted"],
			"blocked" => ["contact", "blocked"],
			"dfrn-notify" => ["contact", "notify"],
			"dfrn-poll" => ["contact", "poll"],
			"diaspora-guid" => ["item-uri", "guid"],
			"diaspora-batch" => ["diaspora-contact", "batch"],
			"diaspora-notify" => ["diaspora-contact", "notify"],
			"diaspora-poll" => ["diaspora-contact", "poll"],
			"diaspora-alias" => ["diaspora-contact", "alias"],
			"ap-uuid" => ["apcontact", "uuid"],
			"ap-type" => ["apcontact", "type"],
			"ap-following" => ["apcontact", "following"],
			"ap-followers" => ["apcontact", "followers"],
			"ap-inbox" => ["apcontact", "inbox"],
			"ap-outbox" => ["apcontact", "outbox"],
			"ap-sharedinbox" => ["apcontact", "sharedinbox"],
			"ap-generator" => ["apcontact", "generator"],
			"ap-posting-restricted" => ["apcontact", "posting-restricted"],
			"ap-following_count" => ["apcontact", "following_count"],
			"ap-followers_count" => ["apcontact", "followers_count"],
			"ap-statuses_count" => ["apcontact", "statuses_count"],
			"site_name" => ["gserver", "site_name"],
			"platform" => ["gserver", "platform"],
			"version" => ["gserver", "version"],
			"server-blocked" => ["gserver", "blocked"],
			"server-failed" => ["gserver", "failed"],
		],
		"query" => "FROM `contact`
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `contact`.`uri-id`
			LEFT JOIN `apcontact` ON `apcontact`.`uri-id` = `contact`.`uri-id`
			LEFT JOIN `diaspora-contact` ON `diaspora-contact`.`uri-id` = contact.`uri-id`
			LEFT JOIN `gserver` ON `gserver`.`id` = contact.`gsid`
			WHERE `contact`.`uid` = 0"
	],
	"account-user-view" => [
		"fields" => [
			"id" => ["ucontact", "id"],
			"pid" => ["contact", "id"],
			"uid" => ["ucontact", "uid"],
			"url" => ["contact", "url"],
			"nurl" => ["contact", "nurl"],
			"uri-id" => ["contact", "uri-id"],
			"guid" => ["item-uri", "guid"],
			"addr" => ["contact", "addr"],
			"alias" => ["contact", "alias"],
			"name" => ["contact", "name"],
			"nick" => ["contact", "nick"],
			"about" => ["contact", "about"],
			"keywords" => ["contact", "keywords"],
			"xmpp" => ["contact", "xmpp"],
			"matrix" => ["contact", "matrix"],
			"avatar" => ["contact", "avatar"],
			"photo" => ["contact", "photo"],
			"thumb" => ["contact", "thumb"],
			"micro" => ["contact", "micro"],
			"header" => ["contact", "header"],
			"created" => ["contact", "created"],
			"updated" => ["contact", "updated"],
			"self" => ["ucontact", "self"],
			"remote_self" => ["ucontact", "remote_self"],
			"rel" =>  ["ucontact", "rel"],
			"network" => ["contact", "network"],
			"protocol" => ["ucontact", "protocol"],
			"location" => ["contact", "location"],
			"attag" => ["ucontact", "attag"],
			"pubkey" => ["contact", "pubkey"],
			"prvkey" => ["contact", "prvkey"],
			"subscribe" => ["contact", "subscribe"],
			"last-update" => ["contact", "last-update"],
			"success_update" => ["contact", "success_update"],
			"failure_update" => ["contact", "failure_update"],
			"failed" => ["contact", "failed"],
			"last-item" => ["contact", "last-item"],
			"last-discovery" => ["contact", "last-discovery"],
			"contact-type" => ["contact", "contact-type"],
			"manually-approve" => ["contact", "manually-approve"],
			"unsearchable" => ["contact", "unsearchable"],
			"sensitive" => ["contact", "sensitive"],
			"baseurl" => ["contact", "baseurl"],
			"gsid" => ["contact", "gsid"],
			"info" => ["ucontact", "info"],
			"bdyear" => ["contact", "bdyear"],
			"bd" => ["contact", "bd"],
			"poco" => ["contact", "poco"],
			"name-date" => ["contact", "name-date"],
			"uri-date" => ["contact", "uri-date"],
			"avatar-date" => ["contact", "avatar-date"],
			"term-date" => ["contact", "term-date"],
			"global-ignored" => ["contact", "hidden"],
			"global-blocked" => ["contact", "blocked"],
			"hidden" => ["ucontact", "hidden"],
			"archive" => ["ucontact", "archive"],
			"pending" => ["ucontact", "pending"],
			"deleted" => ["ucontact", "deleted"],
			"notify_new_posts" => ["ucontact", "notify_new_posts"],
			"fetch_further_information" => ["ucontact", "fetch_further_information"],
			"ffi_keyword_denylist" => ["ucontact", "ffi_keyword_denylist"],
			"rating" => ["ucontact", "rating"],
			"readonly" => ["ucontact", "readonly"],
			"blocked" => ["ucontact", "blocked"],
			"block_reason" => ["ucontact", "block_reason"],
			"hub-verify" => ["ucontact", "hub-verify"],
			"reason" => ["ucontact", "reason"],
			"dfrn-notify" => ["contact", "notify"],
			"dfrn-poll" => ["contact", "poll"],
			"diaspora-guid" => ["item-uri", "guid"],
			"diaspora-batch" => ["diaspora-contact", "batch"],
			"diaspora-notify" => ["diaspora-contact", "notify"],
			"diaspora-poll" => ["diaspora-contact", "poll"],
			"diaspora-alias" => ["diaspora-contact", "alias"],
			"diaspora-interacting_count" => ["diaspora-contact", "interacting_count"],
			"diaspora-interacted_count" => ["diaspora-contact", "interacted_count"],
			"diaspora-post_count" => ["diaspora-contact", "post_count"],
			"ap-uuid" => ["apcontact", "uuid"],
			"ap-type" => ["apcontact", "type"],
			"ap-following" => ["apcontact", "following"],
			"ap-followers" => ["apcontact", "followers"],
			"ap-inbox" => ["apcontact", "inbox"],
			"ap-outbox" => ["apcontact", "outbox"],
			"ap-sharedinbox" => ["apcontact", "sharedinbox"],
			"ap-generator" => ["apcontact", "generator"],
			"ap-posting-restricted" => ["apcontact", "posting-restricted"],
			"ap-following_count" => ["apcontact", "following_count"],
			"ap-followers_count" => ["apcontact", "followers_count"],
			"ap-statuses_count" => ["apcontact", "statuses_count"],
			"site_name" => ["gserver", "site_name"],
			"platform" => ["gserver", "platform"],
			"version" => ["gserver", "version"],
			"server-blocked" => ["gserver", "blocked"],
			"server-failed" => ["gserver", "failed"],
		],
		"query" => "FROM `contact` AS `ucontact`
			INNER JOIN `contact` ON `contact`.`uri-id` = `ucontact`.`uri-id` AND `contact`.`uid` = 0
			LEFT JOIN `item-uri` ON `item-uri`.`id` = `ucontact`.`uri-id`
			LEFT JOIN `apcontact` ON `apcontact`.`uri-id` = `ucontact`.`uri-id`
			LEFT JOIN `diaspora-contact` ON `diaspora-contact`.`uri-id` = `ucontact`.`uri-id`
			LEFT JOIN `gserver` ON `gserver`.`id` = contact.`gsid`"
	],
	"pending-view" => [
		"fields" => [
			"id" => ["register", "id"],
			"hash" => ["register", "hash"],
			"created" => ["register", "created"],
			"uid" => ["register", "uid"],
			"password" => ["register", "password"],
			"language" => ["register", "language"],
			"note" => ["register", "note"],
			"self" => ["contact", "self"],
			"name" => ["contact", "name"],
			"url" => ["contact", "url"],
			"micro" => ["contact", "micro"],
			"email" => ["user", "email"],
			"nick" => ["contact", "nick"],
		],
		"query" => "FROM `register`
			INNER JOIN `contact` ON `register`.`uid` = `contact`.`uid`
			INNER JOIN `user` ON `register`.`uid` = `user`.`uid`
			WHERE `register`.`uid` != 0"
	],
	"tag-search-view" => [
		"fields" => [
			"uri-id" => ["post-tag", "uri-id"],
			"uid" => ["post-user", "uid"],
			"iid" => ["post-user", "id"],
			"private" => ["post-user", "private"],
			"wall" => ["post-user", "wall"],
			"origin" => ["post-user", "origin"],
			"global" => ["post-user", "global"],
			"gravity" => ["post-user", "gravity"],
			"received" => ["post-user", "received"],
			"network" => ["post-user", "network"],
			"protocol" => ["post-user", "protocol"],
			"author-id" => ["post-user", "author-id"],
			"name" => ["tag", "name"],
		],
		"query" => "FROM `post-tag`
			INNER JOIN `tag` ON `tag`.`id` = `post-tag`.`tid`
			STRAIGHT_JOIN `post-user` ON `post-user`.`uri-id` = `post-tag`.`uri-id`
			WHERE `post-tag`.`type` = 1"
	],
	"workerqueue-view" => [
		"fields" => [
			"pid" => ["process", "pid"],
			"priority" => ["workerqueue", "priority"],
		],
		"query" => "FROM `process`
			INNER JOIN `workerqueue` ON `workerqueue`.`pid` = `process`.`pid`
			WHERE NOT `workerqueue`.`done`"
	],
	"profile_field-view" => [
		"fields" => [
			"id" => ["profile_field", "id"],
			"uid" => ["profile_field", "uid"],
			"label" => ["profile_field", "label"],
			"value" => ["profile_field", "value"],
			"order" => ["profile_field", "order"],
			"psid" => ["profile_field", "psid"],
			"allow_cid" => ["permissionset", "allow_cid"],
			"allow_gid" => ["permissionset", "allow_gid"],
			"deny_cid" => ["permissionset", "deny_cid"],
			"deny_gid" => ["permissionset", "deny_gid"],
			"created" => ["profile_field", "created"],
			"edited" => ["profile_field", "edited"],
		],
		"query" => "FROM `profile_field`
			INNER JOIN `permissionset` ON `permissionset`.`id` = `profile_field`.`psid`"
	],
	"diaspora-contact-view" => [
		"fields" => [
			"uri-id" => ["diaspora-contact", "uri-id"],
			"url" => ["item-uri", "uri"],
			"guid" => ["item-uri", "guid"],
			"addr" => ["diaspora-contact", "addr"],
			"alias" => ["diaspora-contact", "alias"],
			"nick" => ["diaspora-contact", "nick"],
			"name" => ["diaspora-contact", "name"],
			"given-name" => ["diaspora-contact", "given-name"],
			"family-name" => ["diaspora-contact", "family-name"],
			"photo" => ["diaspora-contact", "photo"],
			"photo-medium" => ["diaspora-contact", "photo-medium"],
			"photo-small" => ["diaspora-contact", "photo-small"],
			"batch" => ["diaspora-contact", "batch"],
			"notify" => ["diaspora-contact", "notify"],
			"poll" => ["diaspora-contact", "poll"],
			"subscribe" => ["diaspora-contact", "subscribe"],
			"searchable" => ["diaspora-contact", "searchable"],
			"pubkey" => ["diaspora-contact", "pubkey"],
			"baseurl" => ["gserver", "url"],
			"gsid" => ["diaspora-contact", "gsid"],
			"created" => ["diaspora-contact", "created"],
			"updated" => ["diaspora-contact", "updated"],
			"interacting_count" => ["diaspora-contact", "interacting_count"],
			"interacted_count" => ["diaspora-contact", "interacted_count"],
			"post_count" => ["diaspora-contact", "post_count"],
		],
		"query" => "FROM `diaspora-contact`
			INNER JOIN `item-uri` ON `item-uri`.`id` = `diaspora-contact`.`uri-id`
			LEFT JOIN `gserver` ON `gserver`.`id` = `diaspora-contact`.`gsid`"
	],
];
